#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define INF 1000000

typedef struct {
    int cost, x, y;
} Node;

typedef struct {
    Node heap[40000];
    int size;
} PriorityQueue;

void push(PriorityQueue* pq, int cost, int x, int y) {
    pq->heap[pq->size++] = (Node){cost, x, y};
    for (int i = pq->size - 1; i > 0; i--) {
        if (pq->heap[i].cost < pq->heap[(i - 1) / 2].cost) {
            Node temp = pq->heap[i];
            pq->heap[i] = pq->heap[(i - 1) / 2];
            pq->heap[(i - 1) / 2] = temp;
        }
    }
}

Node pop(PriorityQueue* pq) {
    Node min = pq->heap[0];
    pq->heap[0] = pq->heap[--pq->size];
    for (int i = 0, child; (child = 2 * i + 1) < pq->size; i = child) {
        if (child + 1 < pq->size && pq->heap[child + 1].cost < pq->heap[child].cost) {
            child++;
        }
        if (pq->heap[i].cost <= pq->heap[child].cost) break;
        Node temp = pq->heap[i];
        pq->heap[i] = pq->heap[child];
        pq->heap[child] = temp;
    }
    return min;
}

bool isEmpty(PriorityQueue* pq) {
    return pq->size == 0;
}

int main() {
    int L, C, T;
    while (scanf("%d %d %d", &L, &C, &T), L || C || T) {
        int grid[L][C];
        for (int i = 0; i < L; i++) {
            for (int j = 0; j < C; j++) {
                scanf("%d", &grid[i][j]);
            }
        }

        int L1, C1, L2, C2;
        scanf("%d %d %d %d", &L1, &C1, &L2, &C2);
        L1--; C1--; L2--; C2--;

        int dir[4][2] = {{0, 1}, {1, 0}, {0, -1}, {-1, 0}};
        PriorityQueue pq = {0};
        int dist[L][C];
        bool vis[L][C];

        for (int i = 0; i < L; i++) {
            for (int j = 0; j < C; j++) {
                dist[i][j] = INF;
                vis[i][j] = false;
            }
        }

        dist[L1][C1] = grid[L1][C1];
        push(&pq, grid[L1][C1], L1, C1);

        while (!isEmpty(&pq)) {
            Node node = pop(&pq);
            int val = node.cost, x = node.x, y = node.y;

            if (vis[x][y]) continue;
            vis[x][y] = true;

            for (int i = 0; i < 4; i++) {
                int a = x + dir[i][0], b = y + dir[i][1];
                if (a < 0 || a >= L || b < 0 || b >= C || grid[a][b] == -1 || vis[a][b]) {
                    continue;
                }
                if (dist[a][b] > dist[x][y] + grid[a][b]) {
                    dist[a][b] = dist[x][y] + grid[a][b];
                    push(&pq, dist[a][b], a, b);
                }
            }
        }

        int caminhoMinimo = dist[L2][C2] - grid[L2][C2];
        printf("%d\n", T / caminhoMinimo);
    }

    return 0;
}
